@extends('layouts.app')
@section('content')

        <div class="stricky-header stricky-header--one stricked-menu main-menu">
            <div class="sticky-header__content"></div><!-- /.sticky-header__content -->
        </div><!-- /.stricky-header -->


        <!--Start Page Header-->
        <section class="page-header">
            <div class="page-header__bg" style="background-image: url({{ asset('assets/images/backgrounds/page-header-bg.jpg') }})">
            </div>

            <div class="container">
                <div class="page-header__inner text-center">
                    <h2>Training</h2>
                    <div class="icon-box">
                        <span class="icon-right-arrow-1"></span>
                    </div>
                    <ul class="thm-breadcrumb">
                        <li><a href="{{ url('/') }}">Home</a></li>
                        <li><span>-</span></li>
                        <li>Training</li>
                    </ul>
                </div>
            </div>
        </section>
        <!--End Page Header-->

        <!--Start Service Details-->
        <section class="service-details">
            <div class="container">
                <div class="row">
                    <!--Start Service Details Sidebar-->
                    @include('partials.sidebar')
                    <!--End Service Details Sidebar-->

                    <!--Start Service Details Content-->
                    <div class="col-xl-8">
                        <div class="service-details__content">
                            <!--<div class="service-details__content-img1">-->
                            <!--    <img src="{{ asset('assets/images/resources/service-details-img1.jpg') }}" alt="#">-->
                            <!--</div>-->

                            <div class="text-box1">
                                <h2>Training</h2>
                                <p class="text1">As an international recruitment and consulting agency based in the UK, we believe that offering training to prospective employees is a crucial service that can help employers and employees thrive in a global business environment. </p><p>By providing training and development opportunities, we help new hires from around the world adapt to the unique challenges and opportunities of working in the UK.</p>

                                <p class="text2">Training can also help prospective employees acquire the language, cultural, and technical skills needed to succeed in their new roles. For example, training can help non-native English speakers improve their language proficiency, allowing them to communicate effectively with colleagues and clients. It can also provide an opportunity for employees to learn about UK workplace culture and best practices, ensuring that they are able to work effectively and collaboratively with their colleagues.</p><p>Moreover, offering training as part of our recruitment services makes our agency more attractive to job seekers from around the world. By demonstrating a commitment to employee development, we’ve positioned ourselves as a unique brand employer of choice for candidates who are looking for opportunities to grow and learn in a new work environment.
</p>
                            </div>

                            <div class="text-box2">
                                <div class="title-box">
                                    <h2>Our Training Include</h2>
                                </div>
                                <div class="row">
                                    <div class="col-xl-4 col-lg-4 col-md-4">
                                        <div class="working-process-one__single text-center">
                                            <div class="number-box"> 01 </div>
                                            <div class="working-process-one__single-icon"
                                                style="background-image: url({{ asset('assets/images/shapes/working-process-v1-shape1.png') }});">
                                                <span class="icon-learning"></span>
                                            </div>

                                            <div class="working-process-one__single-content">
                                                <h3><a href="javascript::void(0)">Health Care</a></h3>
                                                <p>Precision training for success in diverse medical roles, ensuring adeptness in patient care and industry demands.
                                                </p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-xl-4 col-lg-4 col-md-4">
                                        <div class="working-process-one__single text-center">
                                            <div class="number-box"> 02 </div>
                                            <div class="working-process-one__single-icon"
                                                style="background-image: url({{ asset('assets/images/shapes/working-process-v1-shape1.png') }});">
                                                <span class="icon-advice"></span>
                                            </div>

                                            <div class="working-process-one__single-content">
                                                <h3><a href="javascript::void(0)">I.T</a></h3>
                                                <p>Refine tech skills for optimal performance in a dynamic, evolving digital landscape.
                                                </p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-xl-4 col-lg-4 col-md-4">
                                        <div class="working-process-one__single text-center">
                                            <div class="number-box"> 03 </div>
                                            <div class="working-process-one__single-icon"
                                                style="background-image: url({{ asset('assets/images/shapes/working-process-v1-shape1.png') }});">
                                                <span class="icon-focus-1"></span>
                                            </div>

                                            <div class="working-process-one__single-content">
                                                <h3><a href="javascript::void(0)">Teaching</a></h3>
                                                <p>Foster educators with strong communication, teamwork, and adaptable soft skills for effective classroom engagement and student success.
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="text-box3">
                                <h2>Developing industry-specific skills</h2>
                                <p>Our training programs help job seekers develop the skills and knowledge needed to succeed in their specific industry, from healthcare and IT to construction, teaching, and hospitality.</p>
                            </div>

                            <div class="text-box4">
                                <!--<p class="text1">Suspendisse ridiculus elementum amet pellentesque rutrum libero posuere-->
                                <!--    mind ad faucibus name feugiat aliquet mauris elementum nisla nonummy placerat.-->
                                <!--    Mauris vivamus eros a potenti. Odio malesuada nulla sollicitudin sociis auctor donec-->
                                <!--    dolors aliquet libero odio vele etathment erat semper elite velford tincidunt-->
                                <!--    suspendisse quam malesuada suscipit congue Feugiat quisque nisi eget libero tortor-->
                                <!--    condimentum gravida platea morbi rutrum.</p>-->

                                <h2>Improving communication and teamwork</h2>

                                <p class="text2">Effective communication and teamwork are essential for success in any job. Our training programs focus on developing these critical skills, helping job seekers become more effective collaborators and problem solvers.</p>
                            </div>

                            <div class="text-box6">
                                <h2>Enhancing soft skills</h2>
                                <p>In addition to technical skills, employers also value soft skills such as time management, adaptability, and resilience. Our training programs help job seekers develop these skills, making them more attractive candidates to potential employers.</p>
                                <!--<div class="img-box">-->
                                <!--    <img src="{{ asset('assets/images/services/service-details-img5.jpg') }}" alt="#">-->
                                <!--</div>-->
                            </div>
                            <div class="text-box6">
                                <h2>Keeping up with industry trends</h2>
                                <p>The job market is constantly evolving, and it's important for job seekers to stay up-to-date with the latest trends and developments in their industry. Our training programs provide the latest insights and knowledge, ensuring that job seekers are well-informed and prepared for the job market.</p>
                                <!--<div class="img-box">-->
                                <!--    <img src="{{ asset('assets/images/services/service-details-img5.jpg') }}" alt="#">-->
                                <!--</div>-->
                            </div>
                            <div class="text-box6">
                                <h2>Providing a competitive advantage</h2>
                                <p>In a crowded job market, it can be difficult to stand out from the competition. Our training programs give job seekers a competitive advantage by equipping them with the skills and knowledge needed to succeed in their chosen field. With our help, job seekers can take their careers to the next level and achieve their professional goals.</p>
                            </div>
                        </div>
                    </div>
                    <!--End Service Details Content-->
                </div>
            </div>
        </section>
        <!--End Service Details-->
@endsection