<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Welcome to Mansionablh</title>
    <!-- Favicons Icons -->
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('assets/images/favicons/apple-touch-icon.png')); ?>" />
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('assets/images/favicons/favicon-32x32.png')); ?>" />
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('assets/images/favicons/favicon-16x16.png')); ?>" />
    <link rel="manifest" href="<?php echo e(asset('assets/images/favicons/site.webmanifest')); ?>" />
    <meta name="description" content="We are a team of dedicated professionals who are passionate about connecting skilled workers with exceptional employers and helping them fulfill their career aspirations." />
    
    
    <!-- Facebook  -->
    <meta property="og:url"                content="<?php echo e(url()->current()); ?>" />
    <meta property="og:type"               content="website" />
    <?php echo $__env->yieldContent('meta'); ?>
    <meta property="og:image"              content="<?php echo e(asset('assets/images/slides/sslider-v1-img1.jpg')); ?>" />

    <!-- Fonts -->
    <link
        href="https://fonts.googleapis.com/css2?family=Rajdhani:wght@300;400;500;600;700&amp;family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&amp;display=swap"
        rel="stylesheet">

    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/animate/animate.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/animate/custom-animate.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/bootstrap/css/bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/bootstrap-select/css/bootstrap-select.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/bxslider/jquery.bxslider.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/fontawesome/css/all.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/jquery-magnific-popup/jquery.magnific-popup.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/jquery-ui/jquery-ui.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/nice-select/nice-select.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/nouislider/nouislider.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/nouislider/nouislider.pips.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/odometer/odometer.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/owl-carousel/owl.carousel.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/owl-carousel/owl.theme.default.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/swiper/swiper.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/timepicker/timePicker.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/tiny-slider/tiny-slider.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/vegas/vegas.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/thm-icons/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/slick-slider/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/language-switcher/polyglot-language-switcher.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/reey-font/stylesheet.css')); ?>">

    <!-- template styles -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/styles.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/responsive.css')); ?>" />

</head>

<body>
    <!-- Start Preloader -->
    <div class="loader-wrap">
        <div class="preloader">
            <div class="preloader-close">x</div>
            <div id="handle-preloader" class="handle-preloader">
                <div class="animation-preloader">
                    <div class="spinner"></div>
                    <div class="txt-loading">
                        <span data-text-preloader="m" class="letters-loading">
                            m
                        </span>
                        <span data-text-preloader="a" class="letters-loading">
                            a
                        </span>
                        <span data-text-preloader="n" class="letters-loading">
                            n
                        </span>
                        <span data-text-preloader="s" class="letters-loading">
                            s
                        </span>
                        <span data-text-preloader="i" class="letters-loading">
                            i
                        </span>
                        <span data-text-preloader="o" class="letters-loading">
                            o
                        </span>
                        <span data-text-preloader="n" class="letters-loading">
                            n
                        </span>
                        <span data-text-preloader="a" class="letters-loading">
                            a
                        </span>
                        <span data-text-preloader="b" class="letters-loading">
                            b
                        </span>
                        <span data-text-preloader="l" class="letters-loading">
                            l
                        </span>
                        <span data-text-preloader="h" class="letters-loading">
                            h
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Preloader -->

    <div class="page-wrapper">

        <!--Start Main Header One-->
        <header class="main-header main-header-one">

            <!--Start Main Header One Top-->
            <div class="main-header-one__top">
                <div class="container">
                    <div class="main-header-one__top-inner">

                        <div class="main-header-one__top-left">
                            <ul class="main-header__contact-info">
                                <li>
                                    <div class="inner">
                                        <div class="icon-box">
                                            <span class="icon-envelope"></span>
                                        </div>
                                        <div class="text-box">
                                            <p><a href="mailto:info@mansionablh.co.uk">info@mansionablh.co.uk</a></p>
                                        </div>
                                    </div>
                                </li>

                                <!--<li>-->
                                <!--    <div class="inner">-->
                                <!--        <div class="icon-box">-->
                                <!--            <span class="icon-location1"></span>-->
                                <!--        </div>-->
                                <!--        <div class="text-box">-->
                                <!--            <p>55 Houghend Avenue, Cholton  M21 7SE </p>-->
                                <!--        </div>-->
                                <!--    </div>-->
                                <!--</li>-->
                            </ul>
                        </div>

                        <div class="main-header-one__top-right">
                            <div class="main-header__language-switcher">
                                <div class="inner clearfix">
                                    <div class="icon-box">
                                        <span class="icon-world"></span>
                                    </div>
                                    <div class="language-switcher">
                                        <div id="polyglotLanguageSwitcher">
                                            <form action="#">
                                                <select id="polyglot-language-options">
                                                    <option id="en" value="en" selected>English</option>
                                                </select>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <ul class="main-header-one__top-social-links">
                                <li><a href="https://facebook.com/mansionablh"  target="_blank"><span class="icon-facebook"></span></a></li>
                                <li><a href="https://twitter.com/mansionablh" target="_blank"><span class="icon-twitter"></span></a></li>
                                <li><a href="https://instagram.com/mansionablh/"><span class="icon-instagram"></span></a></li>
                                <li><a href="https://linkedin.com/company/mansionablh"  target="_blank"><span class="icon-linkedin-big-logo"></span></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <!--End Main Header One Top-->

            <!--Start Main Header One Bottom-->
            <div class="main-header-one__bottom">
                <div class="main-header-one__bottom-inner">
                    <nav class="main-menu main-menu-one">
                        <div class="main-menu__wrapper clearfix">
                            <div class="container">
                                <div class="main-menu__wrapper-inner">


                                    <div class="main-header-one__bottom-left">
                                        <div class="logo-box-one">
                                            <a href="<?php echo e(url('/')); ?>">
                                                 <img src="<?php echo e(asset('assets/images/resources/mansionablh.png')); ?>" alt="Mansionablh Logo"
                                                    title=""> 
                                            </a>
                                        </div>
                                    </div>

                                    <div class="main-header-one__bottom-middle">
                                        <div class="main-menu-box">
                                            <a href="#" class="mobile-nav__toggler">
                                                <i class="fa fa-bars"></i>
                                            </a>

                                            <ul class="main-menu__list">
                                                <li>
                                                    <a href="<?php echo e(url('/')); ?>">Home</a>
                                                </li>
                                                <li>
                                                    <a href="<?php echo e(url('/about')); ?>">About</a>
                                                </li>
                                                <li class="dropdown">
                                                    <a href="#">Services</a>
                                                    <ul>
                                                        <li>
                                                            <a href="<?php echo e(url('/services/training')); ?>">Training</a>
                                                        </li>
                                                        <li>
                                                            <a href="<?php echo e(url('/services/recruitment')); ?>">Recruitment</a>
                                                        </li>
                                                        <li>
                                                            <a href="<?php echo e(url('/services/legal-support')); ?>">Legal Support</a>
                                                        </li>
                                                    </ul>
                                                </li>
                                                <li class="dropdown">
                                                    <a href="#">Immigration</a>
                                                    <ul>
                                                        <li>
                                                            <a href="<?php echo e(url('/immigration/skilled-worker-visa')); ?>">Skilled Worker Visa</a>
                                                        </li>
                                                        <li>
                                                            <a href="<?php echo e(url('/immigration/skills-in-high-demand')); ?>">Skills In High Demand</a>
                                                        </li>
                                                    </ul>
                                                </li>
                                                <li>
                                                    <a href="<?php echo e(url('/contact')); ?>">Contact</a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>

                                    <div class="main-header-one__bottom-right">
                                        <div class="header-search-box">
                                            <a href="#"
                                                class="main-menu__search search-toggler icon-search-interface-symbol">
                                            </a>
                                        </div>

                                        <div class="btn-box">
                                            <a class="thm-btn" href="<?php echo e(url('/contact')); ?>">
                                                <span class="txt">contact us</span>
                                                <i class="icon-plus-1"></i>
                                            </a>
                                        </div>

                                    </div>

                                </div>
                            </div>
                        </div>
                    </nav>
                </div>
            </div>
            <!--End Main Header One Bottom-->

        </header>
        <!--End Main Header One-->

        <?php echo $__env->yieldContent('content'); ?>


        <!--Start Footer One -->
        <footer class="footer-one">
            <div class="shape1"><img src="<?php echo e(asset('assets/images/shapes/footer-v1-shape1.png')); ?>" alt="#"></div>
            <div class="shape2"><img src="<?php echo e(asset('assets/images/shapes/footer-v1-shape2.png')); ?>" alt="#"></div>
            <div class="shape3"><img src="<?php echo e(asset('assets/images/shapes/footer-v1-shape3.png')); ?>" alt="#"></div>
            <div class="shape4"><img src="<?php echo e(asset('assets/images/shapes/footer-v1-shape4.png')); ?>" alt="#"></div>
            <!--Start Footer-->
            <div class="footer">
                <div class="container">
                    <div class="row">
                        <!--Start Footer Widget Single-->
                        <div class="col-xl-4 col-lg-6 col-md-6  wow animated fadeInUp" data-wow-delay="0.1s">
                            <div class="footer-widget__single">
                                <div class="footer-widget__single-about">
                                    <div class="logo-box">
                                        <a href="<?php echo e(url('/')); ?>">
                                            <img src="<?php echo e(asset('assets/images/resources/mansionablh.png')); ?>" alt="#">
                                            
                                        </a>
                                    </div>

                                    <div class="footer-widget__single-about-text">
                                        <p>We are a team of dedicated professionals who are passionate about connecting skilled workers with exceptional employers and helping them fulfill their career aspirations.</p>
                                    </div>

                                    <!--<div class="contact-info">-->
                                    <!--    <div class="icon-box">-->
                                    <!--        <span class="icon-call"></span>-->
                                    <!--    </div>-->

                                    <!--    <div class="text-box">-->
                                    <!--        <p>Free Support</p>-->
                                    <!--        <h3><a href="tel:+447404107566">+44 740 4107 566</a></h3>-->
                                    <!--    </div>-->
                                    <!--</div>-->
                                </div>
                            </div>
                        </div>
                        <!--End Footer Widget Single-->

                        <!--Start Footer One Right Single-->
                        <div class="col-xl-2 col-lg-6 col-md-6 wow animated fadeInUp" data-wow-delay="0.2s">
                            <div class="footer-one__right-single footer-one__right-single-services">
                                <div class="title">
                                    <h2>Quick Link</h2>
                                </div>

                                <ul class="footer-one__right-single-services-list">
                                    <li><a href="<?php echo e(url('/services/training')); ?>">Training</a></li>
                                    <li><a href="<?php echo e(url('/services/recruitment')); ?>">Recruitment</a></li>
                                    <li><a href="<?php echo e(url('/services/legal-support')); ?>">Legal Support</a></li>
                                    <li><a href="<?php echo e(url('/immigration/skilled-worker-visa')); ?>">Skilled worker Visa</a></li>
                                    <li><a href="<?php echo e(url('/immigration/skills-in-high-demand')); ?>">Skills in high demand</a></li>
                                </ul>

                            </div>
                        </div>
                        <!--End Footer One Right Single-->

                        <!--Start Footer One Right Single-->
                        <div class="col-xl-3 col-lg-6 col-md-6 wow animated fadeInUp" data-wow-delay="0.3s">
                            <div class="footer-one__right-single footer-one__right-single-contact">
                                <div class="title">
                                    <h2>Contact Us</h2>
                                </div>

                                <div class="footer-one__right-single-contact-box">
                                    <p>2.17 Trafford House, Chester Road, Old Trafford, M32 0RS</p>
                                    <p><a href="tel:+441612147938">+44 161 2147 938</a></p>
                                    <p><a href="mailto:info@mansionablh.co.uk">info@mansionablh.co.uk</a></p>
                                </div>


                            </div>
                        </div>
                        <!--End Footer One Right Single-->

                        <!--Start Footer One Right Single-->
                        <div class="col-xl-3 col-lg-6 col-md-6 wow animated fadeInUp" data-wow-delay="0.4s">
                            <div class="footer-one__right-single footer-one__right-single-project">
                                <div class="title">
                                    <h2>Recent Project</h2>
                                </div>

                                <ul class="footer-one__right-single-project-box">
                                    <li>
                                        <div class="img-box">
                                            <img src="<?php echo e(asset('assets/images/footer/footer-v1-img1.jpg')); ?>" alt="#">

                                            <div class="footer-one__right-single-project-link">
                                                <a class="img-popup"
                                                    href="<?php echo e(asset('assets/images/footer/footer-v1-img1.jpg')); ?>"><span
                                                        class="icon-plus"></span></a>
                                            </div>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="img-box">
                                            <img src="<?php echo e(asset('assets/images/footer/footer-v1-img2.jpg')); ?>" alt="#">
                                            <div class="footer-one__right-single-project-link">
                                                <a class="img-popup"
                                                    href="<?php echo e(asset('assets/images/footer/footer-v1-img2.jpg')); ?>"><span
                                                        class="icon-plus"></span></a>
                                            </div>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="img-box">
                                            <img src="<?php echo e(asset('assets/images/footer/footer-v1-img3.jpg')); ?>" alt="#">
                                            <div class="footer-one__right-single-project-link">
                                                <a class="img-popup"
                                                    href="<?php echo e(asset('assets/images/footer/footer-v1-img3.jpg')); ?>"><span
                                                        class="icon-plus"></span></a>
                                            </div>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="img-box">
                                            <img src="<?php echo e(asset('assets/images/footer/footer-v1-img4.jpg')); ?>" alt="#">
                                            <div class="footer-one__right-single-project-link">
                                                <a class="img-popup"
                                                    href="<?php echo e(asset('assets/images/footer/footer-v1-img4.jpg')); ?>"><span
                                                        class="icon-plus"></span></a>
                                            </div>
                                        </div>
                                    </li>
                                </ul>

                            </div>
                        </div>
                        <!--End Footer One Right Single-->
                    </div>
                </div>
            </div>
            <!--End Footer-->

            <div class="footer-one__bottom">
                <div class="container">
                    <div class="bottom-inner">
                        <div class="copyright">
                            <p>Copyright © <script> document.write(new Date().getFullYear()); </script> by <a href="#">Mansionablh</a> All Rights
                                Reserved.</p>
                        </div>

                        <div class="social-links">
                            <ul>
                                <li><a href="https://facebook.com/mansionablh"  target="_blank"><span class="icon-facebook-1"></span></a></li>
                                <li><a href="https://twitter.com/mansionablh"  target="_blank"><span class="icon-twitter"></span></a></li>
                                <li><a href="https://instagram.com/mansionablh/"><span class="icon-instagram"></span></a></li>
                                <li><a href="https://linkedin.com/company/mansionablh"  target="_blank"><span class="icon-linkedin-big-logo"></span></a></li>
                            </ul>
                        </div>

                        <ul class="footer-one__bottom-menu">
                            <li><a href="<?php echo e(url('/privacy-policy')); ?>">Privacy & Policy</a></li>
                            <li><a href="<?php echo e(url('/terms-and-condition')); ?>">Terms and Condition</a></li>
                            <li><a href="<?php echo e(url('/legal')); ?>">Legal</a></li>
                        </ul>
                    </div>
                </div>
            </div>

        </footer>
        <!--End Footer One-->

    </div>
    <!-- /.page-wrapper -->

    <div class="mobile-nav__wrapper">
        <div class="mobile-nav__overlay mobile-nav__toggler"></div>
        <div class="mobile-nav__content">
            <span class="mobile-nav__close mobile-nav__toggler">
                <i class="icon-plus"></i>
            </span>
            <div class="logo-box">
                <a href="<?php echo e(url('/')); ?>" aria-label="logo image">
                     <img src="<?php echo e(asset('assets/images/resources/mansionablh.png')); ?>" alt="Mansionablh Logo" />
                    
                </a>
            </div>
            <div class="mobile-nav__container"></div>
            <ul class="mobile-nav__contact list-unstyled">
                <li>
                    <i class="fa fa-envelope"></i>
                    <a href="mailto:info@mansionablh.co.uk">info@mansionablh.co.uk</a>
                </li>
                <li>
                    <i class="fa fa-phone-alt"></i>
                    <a href="tel:+441612147938">+44 161 2147 938</a>
                </li>
            </ul>
            <div class="mobile-nav__social">
                <a href="https://twitter.com/mansionablh" class="fab fa-twitter" target="_blank"></a>
                <a href="https://facebook.com/mansionablh"  target="_blank" class="fab fa-facebook-square"></a>
                <a href="https://linkedin.com/company/mansionablh" class="fab fa-linkedin"></a>
                <a href="https://instagram.com/mansionablh/" class="fab fa-instagram"></a>
            </div>

        </div>
    </div>

    <div class="search-popup">
        <div class="search-popup__overlay search-toggler"></div>
        <div class="search-popup__content">
            <form action="#">
                <label for="search" class="sr-only">search here</label>
                <input type="text" id="search" placeholder="Search Here..." />
                <button type="submit" aria-label="search submit" class="thm-btn">
                    <i class="icon-search-interface-symbol"></i>
                </button>
            </form>
        </div>
    </div>


    <a href="#" data-target="html" class="scroll-to-target scroll-to-top">
        <i class="icon-down-arrow"></i>
    </a>

    <script src="<?php echo e(asset('assets/vendors/jquery/jquery-3.6.0.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/bootstrap-select/js/bootstrap-select.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/bxslider/jquery.bxslider.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/circleType/jquery.circleType.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/circleType/jquery.lettering.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/isotope/isotope.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/jquery-ajaxchimp/jquery.ajaxchimp.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/jquery-appear/jquery.appear.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/jquery-magnific-popup/jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/jquery-migrate/jquery-migrate.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/jquery-ui/jquery-ui.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/jquery-validate/jquery.validate.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/nice-select/jquery.nice-select.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/nouislider/nouislider.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/odometer/odometer.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/owl-carousel/owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/parallax/parallax.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/swiper/swiper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/timepicker/timePicker.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/tiny-slider/tiny-slider.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/typed-2.0.11/typed-2.0.11.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/vegas/vegas.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/wnumb/wNumb.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/wow/wow.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/language-switcher/jquery.polyglot.language.switcher.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/jarallax/jarallax.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/slick-slider/slick.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/jquery-circle-progress/jquery.circle-progress.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/progress-bar/knob.js')); ?>"></script>

    <!-- Template js -->
    <script src="<?php echo e(asset('assets/js/custom.js')); ?>"></script>


<!--Start of Tawk.to Script-->
<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src='https://embed.tawk.to/644f6c6b4247f20fefeeaf47/1gvb3v14r';
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);
})();
</script>
<!--End of Tawk.to Script-->

</body>
</html><?php /**PATH /home/mansrrcv/public_html/mansionablh/resources/views/layouts/app.blade.php ENDPATH**/ ?>